##### Fast and Focused
# Instant Slides
	Getting Started with iA Presenter

iA Presenter lets you build presentations fast—on any device, even your phone. Its script-based approach lets you focus on your message.
 
---
### Table of Contents
	1. Write
	2. Structure
	3. Iterate
	4. Design
	5. Action

Separating the different layers of a presentation allows you to focus on one task at a time.

---
## 1. Write
	Start With a Script

Start with an outline, paste from a document, or write from scratch. Don’t get distracted by layout, fonts, or colors. 

---

### Tell Your Story
	The heart of a great presentation is the message. Get the script right before anything else.

Most presentation tools ask you to choose a design and then adjust your story to fit it. iA Presenter flips the process.

---
### Write it
	Think about what you want to achieve. Then write it down like an email.

### Or Paste it
	From DMs to articles, any existing text can become a presentation in no time. Paste your instant messages, a work chat, or a Mastodon thread.

Bonus points if your text is written in Markdown already. Presenter turns it into a structured presentation, instantly.

---
### Use Placeholder Images
	You will be tempted to add images while writing. Resist the temptation. To move fast, use placeholders. Search, choose and place images with the same concentration as a separate task.	

Don’t waste hours online hunting for the perfect image before you’ve written your story. Even if you already have great visuals, don’t let them overpower your message. Focus on the content. Get the order right. Save images for later.

Write until you run out of words. Then organize. Then refine. Repeat until the story is tight.

/Theme/image2.webp 
title: placeholder

---
## 2. Structure
	Separating What You Say and What You Show

Writing and structure go hand in hand. But try not to bounce back and forth. You can start with a basic outline, and modify it later. Do one thing at a time.

---
### Chop Chop
	Type three dashes to split your story up into slides, like this: ---

https://in-app.ia.net/separator.png
x: left

Stick to one idea per slide. Use three dashes (---) to break your story into clean sections. 

---

### Don't show everything
	Make it interesting. Show words and images that make people listen. Don't explain what everyone already sees.

https://in-app.ia.net/visible-spoken.png
x: left

By default, anything you type will be for your eyes only. Think carefully about what you show on the slide. Create tension between what the audience sees and what they hear. Make it interesting. Use words and images that make people curious about what you are going to say next.

---

https://in-app.ia.net/heading.png

### Headings
	Headings are always visible, so make them short, clear, and interesting, as you would in a standard article.

Headings are created in the standard Markdown notation. Add hashes to the start of a line.

https://in-app.ia.net/body.png

### Body Text
	To make a paragraph of plain text visible on the slide add a tab in front of the paragraph.

By default, paragraphs, lists and block quotes are invisible. Adding a tab at the start of the line puts them on the slide.

https://in-app.ia.net/image1.png

### Visuals
	Images, videos, and tables are shown by default. Images can be fine-tuned using filters, positioning, etc. 


Images can be dragged and dropped on the editor. You can use the photo library, search Unsplash, or hot link images and video from the net.

---
	**Most people don't like stuffed slides.** Sometimes, you need to show more on a slide. You may want to discuss a whole paragraph of text. But if you do, be careful. No one likes having slides read aloud word-for-word. We read faster than we can speak, so we get bored hearing what we have already read. Don’t do to your audience what you wouldn't want done to you.

Most of the above text should be put here, in the speaker notes. 

---
## 3. Iterate
	Make It Better With Every Iteration

Go through your slides. Cut fluff. Add emphasis. Rewrite. Tweak a line. With Presenter, you can make edits live—even during your presentation. The layout won’t break.

You can rehearse anywhere. On the bus. On your way to the meeting. Presenter works on any device.

---

### Editor and Thumbnails
	Fine-tune text, structure, and style on the fly. The preview windows will update simultaneously.

https://in-app.ia.net/the-editor.png
x: left
y: top

The size of the thumbnails can be adjusted by adjusting the size of the sidebar.

---

### Editor and Preview
	The presentation is shown in a separate window. Use the arrow keys to go back and forth.

https://in-app.ia.net/the-preview.png
x: left
y: top

Doubleclick on the thumbnails to see a preview of the slide. You can keep the preview window open.

---
### The Teleprompter
	Once you feel confident, press play and rehearse. You will quickly spot what needs more work.

https://in-app.ia.net/the-teleprompter-only.png
x: left
y: top

Clicking on Play will turn the editor into a teleprompter and activate the presentation view on the presentation device. You can't edit in the teleprompter. To go back to the editor press the Play/Stop button again.


---
## 4. Design
	Layout and Themes

Time to put the cherry on the cake. Once the story and structure make sense, shaping the design is simple, fast, and fun.

---

https://in-app.ia.net/12.jpeg

https://in-app.ia.net/10.jpg

https://in-app.ia.net/20.jpg

https://in-app.ia.net/15.jpg

https://in-app.ia.net/13.jpg

Images are a powerful storytelling tool. Make sure you get meaningful hi-res images for full impact. 

Presenter slides adapt automatically to different screens. But images need a bit more care. Make sure key parts are always visible. Use the dropdown next to each image to tweak filters, position, and background.

---

https://in-app.ia.net/responsive.png
size: contain


	Auto-Layout, Built In: The design adjusts itself to any device. No fiddling. No pinching. No problem.

You might need to get used to responsive layouts. On a laptop, two images might appear side by side. On a phone, they’ll stack. That’s by design.

The goal: send your presentation to any screen—no rotating, resizing, fiddling.

---
### The Layout Picker Gives You More Options

https://in-app.ia.net/thumbnails.png
x: left
y: top

If your slide includes two or more elements, some layouts may work better than others. Use the layout picker to test your options. Want a comparison? Stack or split. Need more structure? Try a grid or columns. 

---

https://in-app.ia.net/templates.png
y: top

### Select From a Wide Range of Powerful Designs

We encourage you to choose the right design at the very end. Colors and images are great, but when you work on message and structure, the can be distracting. 

And just as much as it helps to just focus on the script when you write the script, to find the perfect order when you focus on structure, it helps to just focus on design, when you design. Take youyr time to get the perfect fonts, colors and layouts, at the very end. 

When you switch themes—colors, fonts, or layout—Presenter updates everything automatically. No dragging boxes. No readjusting. It just works.

Once your story is clear and your layout is locked in, pick a font, color scheme, and fine-tune. Every theme supports light and dark mode. 

---

## 5. Action
	Teleprompter and Export

You wrote your script, structured your slides, you designed and rehearsed. You’re ready. Still nervous? Presenter comes with a safety net: the teleprompter.

After the presentation is over you can share your presentation as a clean, readable handout.

---
### A Safety Net
	Present from the heart. But in case you get nervous, the teleprompter will help you refresh your memory.

https://in-app.ia.net/tell-your-story-b.png
x: left

If you are well prepared, you won't need speaker notes. But you walk the tightrope more naturally when you know there is a safety net.

---
### Your Audience Sees the Slides
	You See both Thumbnail and Script

Swipe up and down to navigate slides. Swipe left and right to navigate through the script. 

https://in-app.ia.net/tell-your-story.png
x: left

---
### Share and Export: 
	When you’re done, share the presentation as a handout in article form, as a series of images for a Social Media gallery or as a simple PDF.

https://in-app.ia.net/export.png
size: contain
x: right


https://in-app.ia.net/pdf.png
size: contain
x: left

Presenter works across formats. Create, present, or share—right from your phone or desktop.

---
## Now Go and Move Mountains

And yes, you can edit this presentation in the Settings.
For more, check our [How-To](https://ia.net/presenter/how-to) 
